clear 	 	all
set more 	off
***set cd**** 			

*****Data and documentation for SIPP available at: http://www.nber.org/data/survey-of-income-and-program-participation-sipp-data.html*****

********************************************************************************
*Figure 13: Long-term jobless fifteen month-ahead transition rates
********************************************************************************

use 	for_spell_not_emp, clear
sort 	panel_id date

local 	non_emp_dur_measure			not_emp_dummy_dur
local 	non_emp_spell_measure		not_emp_dummy_spell

*SIPP Survey time period
local 	time_period 	2008/2013

*Identify year jobless spell started
gen 	spell_start 	= 0
replace spell_start 	= 1 		if `non_emp_dur_measure' == 1

gen 	spell_start_y 	= 0
replace spell_start_y 	= rhcalyr 	if `non_emp_dur_measure' == 1
bysort 	panel_id `non_emp_spell_measure' (date): egen spell_start_year = max(spell_start_y)


*Determine spell length
bysort panel_id `non_emp_spell_measure' (date): egen spell_length = max(`non_emp_dur_measure')

sort 	panel_id date
foreach l in 15	 						{

*Find EMP/UNEMP/NLF outcome LEAD months later 
foreach var 	in 		any_emp	 		///
						unemployed 		///
						not_lf			{
forval	dur		=		`time_period'		{						
local 	lead	`l'

qui sum wpfinwgt 	if 	F`lead'.`var'_dummy 	==	1 		///
					& 	spell_start_year 		== `dur'	///
					& 	`non_emp_dur_measure' 	==	7		///
					&  	spell_length			>=	7
					
di "`dur'" "   "	 r(sum)
}
}
*

*FTS outcome LEAD months later 
forval	dur		=		`time_period'		{
foreach var 	in 		fts					{
						
local 	lead	`l'

qui sum wpfinwgt 	if 	F`lead'.`var'_dummy 	==	1 		///
					& 	spell_start_year 		== `dur'	///
					& 	F`lead'.fts_dummy_dur 	>	3		///
					& 	`non_emp_dur_measure' 	==	7		///
					&  	spell_length			>=	7	
					
di "`dur'" "   "	 r(sum)
}
}
di `l'
}
*


